var AmpNativeMessaging = (function() {
	let counter = 0;
    let resolveMap = {};
    let callMap = {};

function sendMessageFromNative(callId, data) {
        const resolveFn = resolveMap[callId];
        let datastr = JSON.stringify(data)
        let moddatastr = datastr.replace(/(^"\\"|\\""$)/g, '"')
        let moddataParse = JSON.parse(moddatastr)

        if (!resolveFn) {
            console.log(`Resolve function not found for call id: ${callId}`);
            return;
        }
        const callMapId = callMap[callId]

        // Calls tend to get repeated. This prevents multiple calls from
        if(callMapId) {
            return;
        } else {
            callMap[callId] = callId
        }
        resolveFn({body: moddataParse});
        delete resolveMap[callId];
        return true;
    }

    function waitForMessageFromNative(callId) {
        return new Promise(function(resolve, reject) {
            resolveMap[callId] = resolve;
        });
    }

    async function toInterceptorResponse(response) {
        console.log("toInterceptorResponse" + response)
        return {
            body: await response.text()
        }
    };

    async function passThrough(url, init) {
        return toInterceptorResponse(await fetch(url, init));
    }

    async function xhrHandler(name, data, contextData){
        const callId = `id-${counter++}`;
        const init = data.originalRequest.init;
        const url = data.originalRequest.input;

        if (!init || !url) {
            return;
        }
        // The XHR interceptor actually proxies all requests made with fetch()
        // And apparently the AMP script loader fetches scripts fetch()
        // This leads to script requests also being proxied
        // Since those are in our CDN, do not run them through the AMP proxy
        if (url.startsWith('https://s.yimg.com/')) {
            return passThrough(url, init);
        }

        // Send "data" with "callId" to native to make call to AMPProxy.
        // The callId id used to identifier the promise resolve when the response is returned back to webview.
        // *** Call to Native here
        let datastr = JSON.stringify(data);
        ConversationInterface.getAmpXhrRequest(datastr, callId);

        // Wait for message from Native code.
        return await waitForMessageFromNative(callId);
    }

    return {
        sendMessageFromNative: sendMessageFromNative,
        xhrHandler: xhrHandler
    }
}());
